<?php

//ESTANCIANDO A CLASSE PHPMailer
require ('_app/Library/PHPMailer/class.smtp.php');
require ('_app/Library/PHPMailer/class.phpmailer.php');

/**
 * Email [MODEL]
 * Modelo responsável por configurar a PHPMailer, validar os dados e disparar e-mails do sistema!
 * @copyright (c) year, Guilherme Salomã Shorane - CLÍNICA DE COMPUTADORES
 */
class Email {
    
    /** @var PHPMailer */
    private $Mail;

    /** EMAIL DATA */
    private $Data;

    /* CORPO DO E-MAIL */
    private $Assunto;
    private $Mensagem;

    /* REMETENTE */
    private $RemetenteNome;
    private $RemetenteEmail;

    /* DESTINO */
    private $DestinoNome;
    private $DestinoEmail;

    /* CONTROLE */
    private $Error;
    private $Result;

    //INSTANCIANDO A FUNÇÃO PHPMailer
    function __construct() {
        $this->Mail = new PHPMailer;
        $this->Mail->Host = MAILHOST;
        $this->Mail->Port = MAILPORT;
        $this->Mail->Username = MAILUSER;
        $this->Mail->Password = MAILPASS;
        $this->Mail->SMTPSecure = 'ssl';        
        $this->Mail->CharSet = "UTF-8";
    }

    //ENVIAR E-MAIL
    public function Enviar(array $Data) {
        $this->Data = $Data;
        $this->Clear();

        //VALIDANDO SE PREENCHEU TODOS OS CAMPOS
        if (in_array('', $this->Data)):
            $this->Error = ['Erro ao enviar mensagem: Para enviar esse e-mail. Preencha os campos requisitados.', WS_ERROR];
            $this->Result = FALSE;
        //VALIDANDO SE O E-MAIL É UM FORMATO VÁLIDO
        elseif (!Check::Email($this->Data['RemetenteEmail'])):
            $this->Error = ['Erro ao enviar mensagem: O e-mail que você informou não tem um formato válido ! Informo seu e-mail corretamente !', WS_ERROR];
            $this->Result = FALSE;
        //SE TUDO FOI CORRETO ENVIA O EMAIL
        else:
            $this->setMail();
            $this->Config();
            $this->sendMail();
        endif;
    }
	
    //ENVIAR E-MAIL CUPOM
    public function EnviarCupom(array $Data) {
        $this->Data = $Data;
        $this->Clear();

        //VALIDANDO SE PREENCHEU TODOS OS CAMPOS
        if (in_array('', $this->Data)):
            $this->Error = ['Erro ao enviar mensagem: Para enviar esse e-mail. Preencha os campos requisitados.', WS_ERROR];
            $this->Result = FALSE;
        //VALIDANDO SE O E-MAIL É UM FORMATO VÁLIDO
        elseif (!Check::Email($this->Data['RemetenteEmail'])):
            $this->Error = ['Erro ao enviar mensagem: O e-mail que você informou não tem um formato válido ! Informo seu e-mail corretamente !', WS_ERROR];
            $this->Result = FALSE;
        //SE TUDO FOI CORRETO ENVIA O EMAIL
        else:
            $this->setMailCupom();
            $this->Config();
            $this->sendMail();
        endif;
    }


    function getResult() {
        return $this->Result;
    }

    function getError() {
        return $this->Error;
    }

    //PRIVATES
    //
    //LIMPAR CÓDIGO HTML DA MENSAGEM
    private function Clear() {
        array_map('strip_tags', $this->Data);
        array_map('trim', $this->Data);
    }

    //ENVIA O E-MAIL (CORPO)
    private function setMail() {
        $this->Assunto = $this->Data['Assunto'];
		$this->Mensagem = $this->Data['Mensagem'];
        $this->RemetenteNome = $this->Data['RemetenteNome'];
        $this->RemetenteEmail = $this->Data['RemetenteEmail'];
        $this->DestinoNome = $this->Data['DestinoNome'];
        $this->DestinoEmail = $this->Data['DestinoEmail'];

        //PERSONALIZAÇÃO DO CORPO DO E-MAIL
        $this->Data = NULL;
        $this->setMsg();
    }

    //ENVIA O E-MAIL PARA CUPOM (CORPO)
    private function setMailCupom() {
        $this->Assunto = $this->Data['Assunto'];
		$this->Mensagem = $this->Data['Mensagem'];
        $this->RemetenteNome = $this->Data['RemetenteNome'];
        $this->RemetenteEmail = $this->Data['RemetenteEmail'];
        $this->DestinoNome = $this->Data['DestinoNome'];
        $this->DestinoEmail = $this->Data['DestinoEmail'];

        //PERSONALIZAÇÃO DO CORPO DO E-MAIL
        $this->Data = NULL;
        $this->setMsg();
    }

    //PERSONALIZAÇÃO DO E-MAIL
    private function setMsg() {
        $this->Mensagem = "{$this->Mensagem}<hr><small>Recebida em : " . date('d/m/Y H:i') . "</small>";
    }

    //CONFIGURANDO O PHPMailer
    private function Config() {

        //SMTP AUTENTICADO
        $this->Mail->isSMTP();
        $this->Mail->SMTPAuth = TRUE;
        $this->Mail->isHTML();

        //REMETENTE
        $this->Mail->From = MAILUSER;
        $this->Mail->FromName = $this->RemetenteNome;
        $this->Mail->addReplyTo($this->RemetenteEmail, $this->RemetenteNome);

        //ASSUNTO, MENSAGEM E DESTINO
        $this->Mail->Subject = $this->Assunto;
        $this->Mail->Body = $this->Mensagem;
        $this->Mail->addAddress($this->DestinoEmail, $this->DestinoNome);
    }

    //ENVIA O EMAIL
    private function sendMail() {
        if ($this->Mail->send()):
            //SE ENVIOU O EMAIL RETORNA
            $this->Error = ['Obrigado por entar em contato, estaremos entrando em contato em breve !', WS_ACCEPT];
            $this->Result = TRUE;
        else:
            //SE NÃO ENVIOU RETORNA
            $this->Error = ["Erro ao enviar: Entre em contato com o suporte ( {$this->Mail->ErrorInfo} )", WS_ERROR];
            $this->Result = FALSE;
        endif;
    }

}
