<?php

/**
 * AdminFaculdade.class
 * Respnsável por gerenciar as faculdade no Admin do sistema!
 * 
 * @copyright (c) 2020, Guilherme Salomão
 */

class AdminFaculdade {

    private $Data;
    private $Faculdade;
    private $Error;
    private $Result;

    //Nome da tabela no banco de dados
    const Entity = 'faculdade';

    /**
     * <b>Cadastrar:</b> Envelope os dados de um usuário em um array atribuitivo e execute esse método
     * para cadastrar o mesmo no sistema. Validações serão feitas!
     * @param ARRAY $Data = Atribuitivo
     */
    public function ExeCreate(array $Data) {
        $this->Data = $Data;
        $this->checkData();
        if ($this->Result):
            $this->Create();
        endif;
    }

    /**
     * <b>Atualizar:</b> Envelope os dados em uma array atribuitivo e informe o id 
     * @param INT $Id = Id do usuário
     * @param ARRAY $Data = Atribuitivo
     */
    public function ExeUpdate($Id, array $Data) {
        $this->Faculdade = (int) $Id;
        $this->Data = $Data;

        if (!$this->Data['facu_senha']):
            unset($this->Data['facu_senha']);
        endif;

        $this->checkData();

        if ($this->Result):
            $this->Update();
        endif;
    }

    /**
     * <b>Remover:</b> Informe o ID do registro que deseja remover. 
     * @param INT $Id = Id
     */
    public function ExeDelete($Id) {
        $this->Faculdade = (int) $Id;

        $Read = new Read;
        $Read->ExeRead(self::Entity, "WHERE facu_id = :id", "id={$this->Faculdade}");
        if (!$Read->getResult()):
            $this->Error = ["A FACULDADE que você tentou deletar não existe no sistema !", WS_ERROR];
            $this->Result = false;
        else:
            $Delete = $Read->getResult()[0];
            $deleta = new Delete;
            $deleta->ExeDelete(self::Entity, "WHERE facu_id = :id", "id={$this->Faculdade}");

            $this->Error = ["A FACULDADE <b>{$Delete['facu_nome']}</b> foi removida com sucesso do sistema !", WS_ACCEPT];
            $this->Result = true;
        endif;
    }
	
    /**
     * <b>Verificar Cadastro:</b> Retorna TRUE se o cadastro ou update for efetuado ou FALSE se não.
     * Para verificar erros execute um getError();
     * @return BOOL $Var = True or False
     */
    public function getResult() {
        return $this->Result;
    }

    /**
     * <b>Obter Erro:</b> Retorna um array associativo com um erro e um tipo.
     * @return ARRAY $Error = Array associatico com o erro
     */
    public function getError() {
        return $this->Error;
    }

    /*
     * ***************************************
     * **********  PRIVATE METHODS  **********
     * ***************************************
     */

    //Verifica os dados digitados no formulário
    private function checkData() {
        if (!Check::Email($this->Data['facu_email'])):
            $this->Error = ["O e-email informado não parece ter um formato válido !", WS_ALERT];
            $this->Result = false;
			
        elseif (isset($this->Data['facu_senha']) && (strlen($this->Data['facu_senha']) < 6 || strlen($this->Data['facu_senha']) > 12)):
            $this->Error = ["A senha deve ter entre 6 e 12 caracteres !", WS_INFOR];
            $this->Result = false;
        else:
            $this->checkEmail();
        endif;
    }

    //Verifica usuário pelo e-mail, Impede cadastro duplicado!
    private function checkEmail() {
        $Where = ( isset($this->Faculdade) ? "facu_id != {$this->Faculdade} AND" : '');
        $read = new Read;
        $read->ExeRead(self::Entity, "WHERE {$Where} facu_email = :email", "email={$this->Data['facu_email']}");
        if ($read->getRowCount()):
            $this->Error = ["O e-email informado foi cadastrado no sistema para outra FACULDADE ! Informe outro e-mail !", WS_ERROR];
            $this->Result = false;
        else:
            $this->Result = true;
        endif;
    }

    //Cadastra
    private function Create() {
        $this->Data['facu_senha'] = md5($this->Data['facu_senha']);

		$Create = new Create;
        $Create->ExeCreate(self::Entity, $this->Data);

        if ($Create->getResult()):
            $this->Error = ["A Fauldade <b>{$this->Data['facu_nome']}</b> foi cadastrado com sucesso no sistema !", WS_ACCEPT];
            $this->Result = $Create->getResult();
        endif;
    }

    //Atualiza Usuário!
    private function Update() {
        $Update = new Update;
        if (isset($this->Data['facu_senha'])):
            $this->Data['facu_senha'] = md5($this->Data['facu_senha']);
        endif;
		
        $Update->ExeUpdate(self::Entity, $this->Data, "WHERE facu_id = :id", "id={$this->Faculdade}");
        if ($Update->getResult()):
            $this->Error = ["A FACULDADE <b>{$this->Data['facu_nome']}</b> foi atualizada com sucesso !", WS_ACCEPT];
            $this->Result = true;
        endif;
    }

    //Remove Usuário
    private function Delete() {
        $Delete = new Delete;
        $Delete->ExeDelete(self::Entity, "WHERE facu_id = :id", "id={$this->Faculdade}");
        if ($Delete->getResult()):
            $this->Error = ["FACULDADE removida com sucesso do sistema !", WS_ACCEPT];
            $this->Result = true;
        endif;
    }

}
