<?php

/**
 * AdminQuemSomos.class [ MODEL ADMIN ]
 * Responável por gerenciar QUEM SOMOS no admin do site!
 * 
 * @copyright (c) 2020, Guilherme Salomão
 */

class AdminQuemSomos {

    private $Data;
    private $Id;
    private $Error;
    private $Result;

    //Nome da tabela no banco de dados
    const Entity = 'quemsomos';

    /**
     * <b>Cadastrar:</b> Envelope os dados da empresa em um array atribuitivo e execute esse método
     * para cadastrar a mesma no banco.
     * @param ARRAY $Data = Atribuitivo
     */
    public function ExeCreate(array $Data) {
        $this->Data = $Data;
        if (in_array('', $this->Data)):
            $this->Error = ["Erro ao Cadastrar: Preencha todos os campos !", WS_ALERT];
            $this->Result = false;
        else:
            $this->Create();
        endif;
    }

    /**
     * <b>Atualizar:</b> Envelope os dados em uma array atribuitivo e informe o id 
     * para atualiza-la no banco de dados!
     * @param INT $EmpresaId = Id da Empresa
     * @param ARRAY $Data = Atribuitivo
     */
    public function ExeUpdate($EmpresaId, array $Data) {
        $this->Id = (int) $EmpresaId;
        $this->Data = $Data;
        if (in_array('', $this->Data)):
            $this->Error = ["Erro ao Atualizar: Para atualizar o <b>{$this->Data['quem_titulo']}</b>, preencha todos os campos !", WS_ALERT];
            $this->Result = false;
        else:
            $this->Update();
        endif;
    }

    /**
     * <b>Deleta :</b> Informe o ID  a ser removida para que esse método realize uma
     * checagem excluinto todos os dados nessesários e removendo do banco!
     * @param INT $EmpresaId = Id da empresa!
     */
    public function ExeDelete($Id) {
        $this->Id = (int) $Id;

        $Read = new Read;
        $Read->ExeRead(self::Entity, "WHERE quem_cod = :id", "id={$this->Id}");
        if (!$Read->getResult()):
            $this->Error = ["O título que você tentou deletar não existe no sistema !", WS_ERROR];
            $this->Result = false;
        else:
            $Delete = $Read->getResult()[0];
            $deleta = new Delete;
            $deleta->ExeDelete(self::Entity, "WHERE quem_cod = :id", "id={$this->Id}");

            $this->Error = ["O título <b>{$Delete['quem_titulo']}</b> foi removido com sucesso do sistema !", WS_ACCEPT];
            $this->Result = true;
        endif;
    }

    /**
     * <b>Verificar Ação:</b> Retorna TRUE se ação for efetuada ou FALSE se não. Para verificar erros
     * execute um getError();
     * @return BOOL $Var = True or False
     */
    public function getResult() {
        return $this->Result;
    }

    /**
     * <b>Obter Erro:</b> Retorna um array associativo com um erro e um tipo.
     * @return ARRAY $Error = Array associativo com o erro
     */
    public function getError() {
        return $this->Error;
    }

    /*
     * ***************************************
     * **********  PRIVATE METHODS  **********
     * ***************************************
     */

    //Cadastra no banco!
    private function Create() {
        $Create = new Create;

        $Create->ExeCreate(self::Entity, $this->Data);

        if ($Create->getResult()):
            $this->Error = ["O título <b>{$this->Data['quem_titulo']}</b> foi cadastrado com sucesso no sistema !", WS_ACCEPT];
            $this->Result = $Create->getResult();
        endif;
    }

    //Atualiza no banco!
    private function Update() {
        $Update = new Update;
        $Update->ExeUpdate(self::Entity, $this->Data, "WHERE quem_cod = :id", "id={$this->Id}");
        if ($Update->getRowCount() >= 1):
            $this->Error = ["O título <b>{$this->Data['quem_titulo']}</b> foi atualizado com sucesso !", WS_ACCEPT];
            $this->Result = true;
        endif;
    }

}
