<?php

/**
 * AdminVaga.class [ MODEL ADMIN ]
 * Responável por gerenciar a VAGA DE CORTE no admin do sistema!
 * 
 * @copyright (c) 2020, Guilherme Salomão Clinica de Computadores
 */

class AdminVaga {

    private $Data;
    private $Id;
    private $Error;
    private $Result;

    //Nome da tabela no banco de dados
    const Entity = 'vaga';

    /**
     * <b>Cadastrar:</b> Envelope os dados em um array atribuitivo e execute esse método
     * para cadastrar a mesma no banco.
     * @param ARRAY $Data = Atribuitivo
     */
    public function ExeCreate(array $Data) {
        $this->Data = $Data;
        if (in_array('', $this->Data)):
            $this->Error = ["Erro ao Cadastrar: Para cadastrar um CANDIDATO POR VAGA, preencha todos os campos !", WS_ALERT];
            $this->Result = false;
        else:
            $this->setName();
			$this->sendImagem();
            $this->Create();
        endif;
    }

    /**
     * <b>Atualizar:</b> Envelope os dados em uma array atribuitivo e informe o id de uma empresa
     * para atualiza-la no banco de dados!
     * @param INT $EmpresaId = Id
     * @param ARRAY $Data = Atribuitivo
     */
    public function ExeUpdate($Id, array $Data) {
        $this->Id = (int) $Id;
        $this->Data = $Data;
        if (in_array('', $this->Data)):
            $this->Error = ["Erro ao Cadastrar: Para cadastrar um CANDIDATO POR VAGA, preencha todos os campos !", WS_ALERT];
            $this->Result = false;
        else:
		    //EXCLUINDO A IMAGEM CASO TENHA
	        $Read = new Read;			
			$Read->ExeRead(self::Entity, "WHERE vaga_id = :id", "id={$this->Id}");
			$RedImagem = $Read->getResult()[0];
            if (file_exists('../themes/acinvesti/img/' . $RedImagem['vaga_arquivo']) && !is_dir('../themes/acinvesti/img/' . $RedImagem['vaga_arquivo'])):
                unlink('../themes/acinvesti/img/' . $RedImagem['vaga_arquivo']);
            endif;	
			$this->sendImagem();	
			$this->Update();
        endif;
    }

    /**
     * <b>Deleta Empresas:</b> Informe o ID da empresa a ser removida para que esse método realize uma
     * checagem excluinto todos os dados nessesários e removendo a empresa do banco!
     * @param INT $EmpresaId = Id da empresa!
     */
    public function ExeDelete($Id) {
        $this->Id = (int) $Id;

        $Read = new Read;
        $Read->ExeRead(self::Entity, "WHERE vaga_id = :id", "id={$this->Id}");
        if (!$Read->getResult()):
            $this->Error = ["O CANDIDATO POR VAGA que você tentou deletar não existe no sistema !", WS_ERROR];
            $this->Result = false;
        else:
            $RedImagem = $Read->getResult()[0];
            if (file_exists('../themes/acinvesti/img/' . $RedImagem['vaga_arquivo']) && !is_dir('../themes/acinvesti/img/' . $RedImagem['vaga_arquivo'])):
                unlink('../themes/acinvesti/img/' . $RedImagem['vaga_arquivo']);
            endif;

            $deleta = new Delete;
            $deleta->ExeDelete(self::Entity, "WHERE vaga_id = :id", "id={$this->Id}");

            $this->Error = ["O CANDIDATO POR VAGA <b>{$RedImagem['vaga_titulo']}</b> foi removido com sucesso do sistema !", WS_ACCEPT];
            $this->Result = true;
        endif;
    }

    /**
     * <b>Verificar Ação:</b> Retorna TRUE se ação for efetuada ou FALSE se não. Para verificar erros
     * execute um getError();
     * @return BOOL $Var = True or False
     */
    public function getResult() {
        return $this->Result;
    }

    /**
     * <b>Obter Erro:</b> Retorna um array associativo com um erro e um tipo.
     * @return ARRAY $Error = Array associativo com o erro
     */
    public function getError() {
        return $this->Error;
    }

    /*
     * ***************************************
     * **********  PRIVATE METHODS  **********
     * ***************************************
     */

    //VERIFICA SE NÃO EXISTE UMA NÓTICIA COM O MESMO NOME!
    private function setName() {
        $Read = new Read;
        $Read->ExeRead(self::Entity, "WHERE vaga_titulo = :titulo", "titulo={$this->Data['vaga_titulo']}");
        if ($Read->getResult()):
            $this->Error = ["Já existe um CANDIDATO POR VAGA com mesmo título: <b>{$this->Data['vaga_titulo']}</b>", WS_ERROR];
    	endif;
    }

    //VERIFICANDO SE A IMAGEM ATENDE AOS REQUISITOS
    private function sendImagem() {
		
		$Upload = new Upload;
        $Upload->File($this->Data['vaga_arquivo'], $this->Data['vaga_titulo'], 'vaga');
		if ($Upload->getError()):
			$this->Error = $Upload->getError();
            $this->Result = false;
         else:
            $this->Data['vaga_arquivo'] = $Upload->getResult();
            $this->Result = true;
         endif;

	}

    //VERIFICA SE JÁ EXISTE IMAGEM SE EXISTE EXCLUI
    private function checkCover() {
        $read = new Read;
        $read->ExeRead(self::Entity, "WHERE vaga_id = :id", "id={$this->Id}");

        if ($read->getRowCount()):
            $del = $read->getResult()[0]['vaga_arquivo'];
            if (file_exists("../themes/acinvesti/img/{$del}") && !is_dir("../themes/acinvesti/img/{$del}")):
                unlink("../themes/acinvesti/img/{$del}");
            endif;
        endif;
    }

    //Cadastra a empresa no banco!
    private function Create() {
        $Create = new Create;
        $Create->ExeCreate(self::Entity, $this->Data);
        if ($Create->getResult()):
            $this->Result = $Create->getResult();
            $this->Error = ["O CANDIDATO VAGA <b>{$this->Data['vaga_titulo']}</b> foi cadastrado com sucesso no sistema !", WS_ACCEPT];
        endif;
    }

    //Atualiza a empresa no banco!
    private function Update() {
        $Update = new Update;
        $Update->ExeUpdate(self::Entity, $this->Data, "WHERE vaga_id = :id", "id={$this->Id}");
        if ($Update->getRowCount() >= 1):
            $this->Error = ["O CANDIDATO VAGA <b>{$this->Data['vaga_titulo']}</b> foi atualizado com sucesso !", WS_ACCEPT];
            $this->Result = true;
        endif;
    }

}